/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcinterface1122.BuilderEntityRenderForwarder;
import mcinterface1122.WrapperItemStack;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfaceRender;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.GIFParser;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceRender
implements IInterfaceRender {
    private static final DoubleBuffer buffer = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder()).asDoubleBuffer();
    private static final Map<String, ResourceLocation> internalTextures = new HashMap<String, ResourceLocation>();
    private static final Map<String, Integer> onlineTextures = new HashMap<String, Integer>();
    private static final Map<String, GIFParser.ParsedGIF> animatedGIFs = new HashMap<String, GIFParser.ParsedGIF>();
    private static final Map<GIFParser.ParsedGIF, Map<GIFParser.GIFImageFrame, Integer>> animatedGIFFrames = new LinkedHashMap<GIFParser.ParsedGIF, Map<GIFParser.GIFImageFrame, Integer>>();
    private static final List<GUIComponentItem> stacksToRender = new ArrayList<GUIComponentItem>();
    private static float lastLightmapX;
    private static float lastLightmapY;
    private static final ResourceLocation MISSING_TEXTURE;
    private static final Map<RenderableVertices, Set<RenderableData>> objectMap;
    private static final Map<RenderableVertices, Integer> cachedIndexMap;
    protected static int lastRenderPassActualPass;

    @Override
    public float[] getBlockBreakTexture(AWrapperWorld world, Point3D position) {
        IBlockState state = ((WrapperWorld)world).world.func_180495_p(new BlockPos(position.x, position.y, position.z));
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        return new float[]{sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h()};
    }

    @Override
    public float[] getDefaultBlockTexture(String name) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174952_b().func_110572_b(name.replace(":", ":blocks/"));
        return new float[]{sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h()};
    }

    @Override
    public String getDefaultFontTextureFolder() {
        return "/assets/minecraft/textures/font";
    }

    @Override
    public InputStream getTextureStream(String name) {
        try {
            String domain = name.substring("/assets/".length(), name.indexOf("/", "/assets/".length()));
            String location = name.substring("/assets/".length() + domain.length() + 1);
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(domain, location)).func_110527_b();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void renderItemModel(GUIComponentItem component) {
        stacksToRender.add(component);
    }

    @Override
    public void renderVertices(RenderableData data, boolean changedSinceLastRender) {
        if (data.lightingMode.disableWorldLighting || data.vertexObject.isLines) {
            InterfaceRender.setLightingState(false);
        }
        if (data.lightingMode.disableTextureShadows) {
            InterfaceRender.setSystemLightingState(false);
        }
        if (data.enableBrightBlending) {
            InterfaceRender.setBlendBright(true);
        }
        if (data.texture != null) {
            InterfaceRender.bindTexture(data.texture);
        } else {
            GL11.glDisable((int)3553);
        }
        GlStateManager.func_179131_c((float)data.color.red, (float)data.color.green, (float)data.color.blue, (float)data.alpha);
        if (!data.lightingMode.disableWorldLighting && !data.vertexObject.isLines) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(data.worldLightValue % 65536), (float)(data.worldLightValue / 65536));
        }
        GL11.glPushMatrix();
        InterfaceRender.applyTransformOpenGL(data.transform);
        if (data.vertexObject.cacheVertices && (Integer)ConfigSystem.client.renderingSettings.renderingMode.value != 2) {
            objectMap.computeIfAbsent(data.vertexObject, k -> new HashSet()).add(data);
            int cachedVertexIndex = cachedIndexMap.computeIfAbsent(data.vertexObject, k -> {
                int newIndex = GL11.glGenLists((int)1);
                GL11.glNewList((int)newIndex, (int)4864);
                InterfaceRender.renderVertices(data.vertexObject.vertices);
                GL11.glEndList();
                return newIndex;
            });
            GL11.glCallList((int)cachedVertexIndex);
        } else if (data.vertexObject.isLines) {
            InterfaceRender.renderLines(data.vertexObject.vertices);
        } else {
            InterfaceRender.renderVertices(data.vertexObject.vertices);
        }
        GL11.glPopMatrix();
        if (data.texture == null) {
            GL11.glEnable((int)3553);
        }
        if (data.lightingMode.disableWorldLighting || data.lightingMode.disableTextureShadows || data.vertexObject.isLines) {
            InterfaceRender.setLightingState(true);
        }
        if (data.enableBrightBlending) {
            InterfaceRender.setBlendBright(false);
        }
    }

    @Override
    public void deleteVertices(RenderableData data) {
        Set<RenderableData> set;
        if (data.vertexObject.cacheVertices && (set = objectMap.get(data.vertexObject)) != null) {
            set.remove(data);
            if (set.isEmpty()) {
                objectMap.remove(data.vertexObject);
                GL11.glDeleteLists((int)cachedIndexMap.remove(data.vertexObject), (int)1);
            }
        }
    }

    @Override
    public boolean bindURLTexture(String textureURL, InputStream stream) {
        if (stream != null) {
            try {
                BufferedImage image = TextureUtil.func_177053_a((InputStream)stream);
                int glTexturePointer = TextureUtil.func_110996_a();
                TextureUtil.func_110989_a((int)glTexturePointer, (BufferedImage)image, (boolean)false, (boolean)false);
                onlineTextures.put(textureURL, glTexturePointer);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        onlineTextures.put(textureURL, TextureUtil.field_111001_a.func_110552_b());
        return false;
    }

    @Override
    public boolean bindURLGIF(String textureURL, GIFParser.ParsedGIF gif) {
        HashMap<GIFParser.GIFImageFrame, Integer> gifFrameIndexes = new HashMap<GIFParser.GIFImageFrame, Integer>();
        for (GIFParser.GIFImageFrame frame : gif.frames.values()) {
            int glTexturePointer = TextureUtil.func_110996_a();
            TextureUtil.func_110989_a((int)glTexturePointer, (BufferedImage)frame.getImage(), (boolean)false, (boolean)false);
            gifFrameIndexes.put(frame, glTexturePointer);
        }
        animatedGIFs.put(textureURL, gif);
        animatedGIFFrames.put(gif, gifFrameIndexes);
        return true;
    }

    @Override
    public int getLightingAtPosition(Point3D position) {
        return Minecraft.func_71410_x().field_71441_e.func_175626_b(new BlockPos(position.x, position.y, position.z), 0);
    }

    @Override
    public boolean shouldRenderBoundingBoxes() {
        return Minecraft.func_71410_x().func_175598_ae().func_178634_b();
    }

    private static void renderVertices(FloatBuffer vertices) {
        GL11.glBegin((int)4);
        while (vertices.hasRemaining()) {
            GL11.glNormal3f((float)vertices.get(), (float)vertices.get(), (float)vertices.get());
            GL11.glTexCoord2f((float)vertices.get(), (float)vertices.get());
            GL11.glVertex3f((float)vertices.get(), (float)vertices.get(), (float)vertices.get());
        }
        GL11.glEnd();
        vertices.rewind();
    }

    private static void renderLines(FloatBuffer vertices) {
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)1);
        while (vertices.hasRemaining()) {
            GL11.glVertex3f((float)vertices.get(), (float)vertices.get(), (float)vertices.get());
        }
        GL11.glEnd();
        vertices.rewind();
        GL11.glLineWidth((float)1.0f);
    }

    protected static void applyTransformOpenGL(TransformationMatrix matrix) {
        buffer.clear();
        buffer.put(matrix.m00);
        buffer.put(matrix.m10);
        buffer.put(matrix.m20);
        buffer.put(matrix.m30);
        buffer.put(matrix.m01);
        buffer.put(matrix.m11);
        buffer.put(matrix.m21);
        buffer.put(matrix.m31);
        buffer.put(matrix.m02);
        buffer.put(matrix.m12);
        buffer.put(matrix.m22);
        buffer.put(matrix.m32);
        buffer.put(matrix.m03);
        buffer.put(matrix.m13);
        buffer.put(matrix.m23);
        buffer.put(matrix.m33);
        buffer.flip();
        GL11.glMultMatrix((DoubleBuffer)buffer);
    }

    private static void bindTexture(String textureLocation) {
        if (animatedGIFs.containsKey(textureLocation)) {
            GIFParser.ParsedGIF parsedGIF = animatedGIFs.get(textureLocation);
            GlStateManager.func_179144_i((int)animatedGIFFrames.get(parsedGIF).get(parsedGIF.getCurrentFrame()));
        } else if (onlineTextures.containsKey(textureLocation)) {
            GlStateManager.func_179144_i((int)onlineTextures.get(textureLocation));
        } else if (textureLocation.equals("GLOBAL")) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        } else {
            if (!internalTextures.containsKey(textureLocation)) {
                String formattedLocation = textureLocation;
                if (textureLocation.contains(":")) {
                    formattedLocation = "/assets/" + textureLocation.replace(":", "/");
                }
                if (InterfaceRender.class.getResource(formattedLocation) != null) {
                    String domain = formattedLocation.substring("/assets/".length(), formattedLocation.indexOf("/", "/assets/".length()));
                    String location = formattedLocation.substring("/assets/".length() + domain.length() + 1);
                    internalTextures.put(textureLocation, new ResourceLocation(domain, location));
                } else {
                    InterfaceManager.coreInterface.logError("Could not find texture: " + formattedLocation + " Reverting to fallback texture.");
                    internalTextures.put(textureLocation, MISSING_TEXTURE);
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(internalTextures.get(textureLocation));
        }
    }

    protected static void renderGUI(int mouseX, int mouseY, int screenWidth, int screenHeight, float partialTicks, boolean updateGUIs) {
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        InterfaceRender.setLightingState(true);
        int displayGUIIndex = 0;
        for (AGUIBase gui : AGUIBase.activeGUIs) {
            if (updateGUIs || gui.components.isEmpty()) {
                gui.setupComponentsInit(screenWidth, screenHeight);
            }
            GL11.glPushMatrix();
            if (gui.capturesPlayer()) {
                GL11.glTranslated((double)0.0, (double)0.0, (double)250.0);
            } else {
                GL11.glTranslated((double)0.0, (double)0.0, (double)(-500 + 250 * displayGUIIndex++));
            }
            InterfaceRender.setBlend(false);
            gui.render(mouseX, mouseY, false, partialTicks);
            InterfaceRender.setBlend(true);
            gui.render(mouseX, mouseY, true, partialTicks);
            if (!stacksToRender.isEmpty()) {
                InterfaceRender.setBlend(false);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                InterfaceRender.setInternalLightingState(false);
                for (GUIComponentItem component : stacksToRender) {
                    if ((WrapperItemStack)component.stackToRender == null) continue;
                    float zOffset = Minecraft.func_71410_x().func_175599_af().field_77023_b;
                    Minecraft.func_71410_x().func_175599_af().field_77023_b = (float)component.translation.z - 100.0f;
                    if ((double)component.scale != 1.0) {
                        GL11.glPushMatrix();
                        GL11.glScalef((float)component.scale, (float)component.scale, (float)1.0f);
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(((WrapperItemStack)component.stackToRender).stack, (int)(component.translation.x / (double)component.scale), (int)(-(component.translation.y / (double)component.scale)) + 1);
                        GL11.glPopMatrix();
                    } else {
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(((WrapperItemStack)component.stackToRender).stack, (int)component.translation.x, (int)(-component.translation.y));
                    }
                    Minecraft.func_71410_x().func_175599_af().field_77023_b = zOffset;
                }
                stacksToRender.clear();
                InterfaceRender.setInternalLightingState(true);
                InterfaceRender.setBlend(true);
            }
            GL11.glPopMatrix();
        }
        InterfaceRender.setLightingState(false);
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        RenderHelper.func_74518_a();
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public static void onIVRenderLast(RenderWorldLastEvent event) {
        RenderHelper.func_74519_b();
        InterfaceRender.setLightingState(true);
        for (lastRenderPassActualPass = 0; lastRenderPassActualPass < 2; ++lastRenderPassActualPass) {
            if (lastRenderPassActualPass == 1) {
                InterfaceRender.setBlend(true);
                GlStateManager.func_179132_a((boolean)false);
            }
            if (BuilderEntityRenderForwarder.lastClientInstance != null) {
                Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)BuilderEntityRenderForwarder.lastClientInstance).func_76986_a((Entity)BuilderEntityRenderForwarder.lastClientInstance, 0.0, 0.0, 0.0, 0.0f, event.getPartialTicks());
            }
            if (lastRenderPassActualPass != 1) continue;
            InterfaceRender.setBlend(false);
            GlStateManager.func_179132_a((boolean)true);
        }
        RenderHelper.func_74518_a();
        InterfaceRender.setLightingState(false);
    }

    private static void setLightingState(boolean enabled) {
        InterfaceRender.setSystemLightingState(enabled);
        InterfaceRender.setInternalLightingState(enabled);
    }

    private static void setSystemLightingState(boolean enabled) {
        if (enabled) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    private static void setInternalLightingState(boolean enabled) {
        if (enabled) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastLightmapX, (float)lastLightmapY);
        } else {
            lastLightmapX = OpenGlHelper.lastBrightnessX;
            lastLightmapY = OpenGlHelper.lastBrightnessY;
            int lightVar = 0xF000F0;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(lightVar % 65536), (float)(lightVar / 65536));
        }
    }

    private static void setBlend(boolean enabled) {
        if (enabled) {
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
        }
    }

    private static void setBlendBright(boolean enabled) {
        if (enabled) {
            GlStateManager.func_179112_b((int)774, (int)770);
        } else {
            GlStateManager.func_179112_b((int)770, (int)771);
        }
    }

    static {
        MISSING_TEXTURE = new ResourceLocation("mts:textures/rendering/missing.png");
        objectMap = new HashMap<RenderableVertices, Set<RenderableData>>();
        cachedIndexMap = new HashMap<RenderableVertices, Integer>();
    }
}

